// Function to generate a random number within a range
    function getRandom(min, max) {
      return Math.random() * (max - min) + min;
    }

    // Function to draw a branch
    function drawBranch(svg, x1, y1, angle, length, depth) {
      if (depth === 0) return;
      
      const x2 = x1 + length * Math.cos(angle);
      const y2 = y1 + length * Math.sin(angle);

      // Create a line element for the branch
      const line = document.createElementNS("http://www.w3.org/2000/svg", "line");
      line.setAttribute("x1", x1);
      line.setAttribute("y1", y1);
      line.setAttribute("x2", x2);
      line.setAttribute("y2", y2);
      line.setAttribute("stroke", "black");
      line.setAttribute("stroke-width", 2);
      svg.appendChild(line);

      // Draw child branches
      let numBranches = Math.floor(getRandom(1, 3));
      if (depth === 1) numBranches = 1
      for (let i = 0; i < numBranches; i++) {
        const newAngle = angle + getRandom(-0.6, 0.6); // Random angle variation
        const newLength = length * getRandom(0.6, 0.8); // Random length reduction
        drawBranch(svg, x2, y2, newAngle, newLength, depth - 1);
      }
    }

    // Get the SVG element
    const svg = document.getElementById("tree");

    // Get random starting position and angle
    const startX = 200;
    const startY = 400;
    const startAngle = -Math.PI / 2; // Pointing upwards

    // Start drawing the tree
    drawBranch(svg, startX, startY, startAngle, 60, 6);