function getRandomInt(min, max) {
    return Math.floor(Math.random() * (max - min + 1)) + min;
}

function getRandomColor() {
    const colors = ['#fbaf00ff', '#ffd639ff', '#ffa3afff', '#007cbeff', '#00af54ff'];
    return colors[getRandomInt(0, colors.length - 1)];
}

function drawLine(x1, y1, x2, y2, width, color) {
    const line = document.createElementNS("http://www.w3.org/2000/svg", "line");
    line.setAttribute("x1", x1);
    line.setAttribute("y1", y1);
    line.setAttribute("x2", x2);
    line.setAttribute("y2", y2);
    line.setAttribute("stroke", color);
    line.setAttribute("stroke-width", width);
    return line;
}

function drawRect(x, y, width, height, fill) {
    const rect = document.createElementNS("http://www.w3.org/2000/svg", "rect");
    rect.setAttribute("x", x);
    rect.setAttribute("y", y);
    rect.setAttribute("width", width);
    rect.setAttribute("height", height);
    rect.setAttribute("fill", fill);
    return rect;
}

function createBook(x, maxHeight, color, rotation = 0) {
    const height = getRandomInt(120, 160);
    const width = getRandomInt(20, 40);
    const numPages = getRandomInt(4, 8);
    const pageWidth = getRandomInt(1, 3);
    const coverWidth = getRandomInt(2, 4);
    const spaceBetweenPagesAndCovers = coverWidth;

    x += coverWidth / 2;

    const yOffset = maxHeight - height;

    const bookGroup = document.createElementNS("http://www.w3.org/2000/svg", "g");

    // Calculate the rotation's horizontal shift
    const radians = rotation * Math.PI / 180;
    const horizontalShift = width * Math.cos(radians) + height * Math.sin(radians);

    // Determine the rotation center
    let rotateX, rotateY = maxHeight;
    if (rotation < 0) {
        // Rotate around the bottom left point
        rotateX = x;
    } else {
        // Rotate around the bottom right point
        rotateX = x + width;
    }
    bookGroup.setAttribute("transform", `rotate(${rotation}, ${rotateX}, ${rotateY})`);

    // Draw the white rectangle as the book background
    bookGroup.appendChild(drawRect(x - 5, yOffset - 5, width + 10, height + 10, 'blue'));

    // Draw the white rectangle as the book background
    bookGroup.appendChild(drawRect(x, yOffset, width, height, 'white'));

    // Create back cover
    bookGroup.appendChild(drawLine(x, yOffset, x, yOffset + height, coverWidth, color));

    // Create pages
    let currentX = x + coverWidth + spaceBetweenPagesAndCovers;
    for (let i = 0; i < numPages; i++) {
        bookGroup.appendChild(drawLine(currentX, yOffset, currentX, yOffset + height, pageWidth, color));
        currentX += pageWidth + spaceBetweenPagesAndCovers;
    }

    // Create front cover
    bookGroup.appendChild(drawLine(currentX, yOffset, currentX, yOffset + height, coverWidth, color));

    return { bookGroup, width, horizontalShift };
}

function generateBooks() {
    const svg = document.getElementById("books-svg");
    let currentX = 0;
    let bookCounter = 0;
    const maxHeight = 160;

    while (currentX < 1000) {
        const color = getRandomColor();
        // Rotate one out of every four books
        const rotation = (bookCounter % 4 === 0) ? getRandomInt(-15, 15) : 0;
        const { bookGroup, width, horizontalShift } = createBook(currentX, maxHeight, color, rotation);
        svg.appendChild(bookGroup);

        if (rotation === 0) {
            // Update currentX for the next book with random spacing
            currentX += width + getRandomInt(10, 20);
        } else {
            // Adjust currentX for the next book based on the rotation shift
            currentX += horizontalShift;
        }

        bookCounter++;
    }
}

// Run the function to generate books
generateBooks();
