const b = document.body;

const slices = 4;
const minWidth = 35;
const span = 300;
const baseCenter = 180;

let lastX = innerWidth / 2;
let energy = 0;

var w = window.innerWidth;
var h = window.innerHeight;

// random function helper
function r(min, max) {
  return Math.floor(Math.random() * (max - min + 1)) + min;
}

b.style.setProperty('--x', `${w / 3 + r(0, w / 3)}px` );
b.style.setProperty('--y', `${h / 3 + r(0, h / 3)}px` );

function updateFromMouse(e) {
  // mouse velocity 
  const dx = e.clientX - lastX;
  lastX = e.clientX;

  // accumulate energy, decay naturally
  energy = energy * 0.8 + Math.abs(dx) * 0.4;

  // widths react to energy
  const widths = [];
  let total = 0;

  for (let i = 0; i < slices; i++) {
    const w =
      minWidth +
      (Math.sin(energy * 0.02 + i) + 1) * 20;

    widths.push(w);
    total += w;
  }

  const scale = span / total;

  // base drifts slightly but never hits 0/360
  const base =
    baseCenter +
    Math.sign(dx) * Math.min(energy, 40) -
    span / 2;

  let angle = base;
  b.style.setProperty(`--a0`, `${angle}deg`);

  for (let i = 0; i < slices; i++) {
    angle += widths[i] * scale;
    b.style.setProperty(`--a${i + 1}`, `${angle}deg`);
  }
}

window.addEventListener("mousemove", updateFromMouse);
