var map = document.getElementById("map");
var container = document.getElementById("container");
var offsetX, offsetY, containerWidth, containerHeight, maxOffsetX, maxOffsetY, containerTop, containerLeft;

// additional size
var additionalSize = 500;

function init() {
    return new Promise(function (resolve) {
        calculateMapSize();
        resolve();
    });
}

function calculateMapSize() {
    // compute container size and position
    var rect = container.getBoundingClientRect();
    containerWidth = rect.width;
    containerHeight = rect.height;
    containerTop = rect.top;
    containerLeft = rect.left;

    // compute image (content) size
    var mapWidth = containerWidth + additionalSize;
    var mapHeight = containerHeight + additionalSize;

    // set map size
    map.style.width = mapWidth + "px";
    map.style.height = mapHeight + "px";

    // compute max offset 
    maxOffsetX = mapWidth - containerWidth;
    maxOffsetY = mapHeight - containerHeight;

    // center image
    offsetX = maxOffsetX / 2;
    offsetY = maxOffsetY / 2;
    map.style.transform = "translate(" + -offsetX + "px, " + -offsetY + "px)";
}

function updateMapPosition(event) {
    // take container position into account
    var mouseX = event.clientX - containerLeft;
    var mouseY = event.clientY - containerTop;

    // compute offsets
    offsetX = (mouseX / containerWidth) * maxOffsetX;
    offsetY = (mouseY / containerHeight) * maxOffsetY;

    map.style.transform = "translate(" + -offsetX + "px, " + -offsetY + "px)";
}

// init, then listen to mousemove
init().then(function () {
    container.addEventListener("mousemove", updateMapPosition);
});

// on resize
window.addEventListener("resize", function (e) {
    calculateMapSize();
});
