// pour chaque lien, au click, affiche l’article
const links = document.querySelectorAll('a[href^="#"]'); // ← tous les <a> dont l’attribut href commence par #
links.forEach(link => {
  link.onclick = () => {
    const article_id = link.getAttribute('href');
    showArticle(article_id);
  }
});

// fonction pour afficher un article (à partir de son id: #id_de_larticle )
function showArticle(article_id){
  // le premier élément (article) visible
  let visible = document.querySelector('.visible');
  // cache le précédent article visible
  visible.classList.remove("visible");
  // détermine le nouvel article à afficher
  visible = document.querySelector(article_id);
  // lui ajoute la class “visible”
  visible.classList.add("visible");
  // si une vidéo est présente dans l’article désormais visible…
  const video_in_article = visible.querySelector("video");
  if(video_in_article){
    // lit la vidéo
    video_in_article.play();
    // à la fin de la vidéo, ajoute la class “ended” à l’article,
    // ce qui a pour effet (en css) d’afficher les questions
    video_in_article.addEventListener('ended', () => {
        visible.classList.add("ended")
    })
  }
}

// rafraichissement de page
if(window.location.hash) {
  let article_id = window.location.hash;	
  showArticle(article_id);	
}

// boutons ← / → du navigateur
window.addEventListener("popstate", (e) => {
  let article_id = window.location.hash;	
  showArticle(article_id);	
})
