/*
Minimal custom audioplayer

  <!-- audio element -->
  <audio src="" id="audio"></audio>

  <!-- links to mp3 files -->
  <a href="mp3/chorale-happy.mp3">happy</a>
  <a href="mp3/chorale-hello.mp3">hello</a>
  <a href="mp3/chorale-radioactive.mp3">radioactive</a>
  <a href="mp3/chorale-roar.mp3">roar</a>
  <a href="mp3/chorale-shape-of-you.mp3">shape-of-you</a>
  <a href="mp3/chorale-uptown-funk.mp3">uptown-funk</a>

  <!-- player element -->
  <div id="player">
    <div class="progress"><div class="bar"></div></div>
    <button class="playpause" disabled></button>
  </div>

*/


var audio = document.querySelector('#audio');
var player = document.querySelector('#player');
var progress = document.querySelector('.progress');
var bar = document.querySelector('.bar');
var playpause = document.querySelector('.playpause');

var links = document.querySelectorAll('a');

links.forEach( (link) => {
  link.addEventListener('click', function(e){
    e.preventDefault();
    audio.src = link.href;
    initPlayer();
  })
})

function initPlayer(){
  audio.play();
  playpause.textContent = "pause";
  player.classList.add('playing');
  playpause.removeAttribute('disabled');
  playpause.addEventListener('click', playPause);
  audio.addEventListener('timeupdate', updateProgress);
  audio.addEventListener('ended', onEnded);
  progress.addEventListener('click', setCue);
}

function playPause(){
  if(audio.paused){
    audio.play();
    player.classList.add('playing');
    playpause.textContent = "pause";
  } else {
    audio.pause();
    player.classList.remove('playing');
    playpause.textContent = "play"
  }
}

function setCue(e){
  var bcr = this.getBoundingClientRect();
  var percent = (e.clientX - bcr.left) / bcr.width;
  audio.currentTime = audio.duration * percent;
}

function updateProgress() {
  var current = audio.currentTime;
  var percent = (current / audio.duration) * 100;
  bar.style.width = percent + '%';  
}

function onEnded() {
  var nextLink = document.querySelector("a[href='" + audio.getAttribute('src')+ "']").nextElementSibling;
  if(nextLink){
    audio.src = nextLink.href;
    initPlayer();    
  }
}