var list = document.querySelector('ol');
var cards = list.querySelectorAll('li');
const transition = "all 250ms";

var wh = window.innerHeight,
    ww = window.innerWidth;
const margin = 10;

const width = (ww - margin * 14) / 13;
const height = width * 3 / 2;



cards.forEach( (card, idx)=> {
  resetCard(card, idx);
  card.onclick = () => {
    card.classList.toggle('is-flipped');
  };
});


const moveCardsCallback = (action, delay) => () => moveCards(action, delay);

var shuffle = document.querySelector('button');
shuffle.onclick = () => {
  moveCards('shuffle', 2600)
    .then(moveCardsCallback('order', 100))
    .then(moveCardsCallback('reset', 100));
};

const moveCards = (action, delay) => new Promise((resolve, reject) => {
  switch(action) {
    case "shuffle":
      cards.forEach( (card, idx) => {
         moveCard(card, idx);
      })
      setTimeout(resolve, delay);
      break;
    
    case "order":
      for (i = cards.length; i >= 0; i--) {
          list.appendChild(cards[Math.random() * i | 0]);
      }
      cards = list.querySelectorAll('li');
      setTimeout(resolve, delay);
      break;
    
    case "reset":
      console.log("reset")
      cards.forEach( (card, idx) => {
         resetCard(card, idx);
      })
      setTimeout(resolve, delay);
      break;
    }
});



function moveCard(card, idx) {
  var size = card.getBoundingClientRect();
  var w = Math.floor(width),
      h = Math.floor(height),
      l = Math.floor(Math.random() * (ww - margin - w ) ),
      t = Math.floor(Math.random() * (wh - margin - h ) );
  setTimeout( () => {
    card.style.left = l + 'px'; 
    card.style.top = t + 'px';
  }, idx * 50);
}

function resetCard(card, idx) {   
  setTimeout( () => {
    card.style.width = width + 'px';
    const col = (idx % 13) ;
    card.style.left =  (margin + col * (width + margin)) + 'px';
    const row = ((idx / 13) | 0) ;
    card.style.top = (100 + margin + row * (height + margin)) + 'px';
  }, idx * 10)  
}