function bingo(){
  // sélectioonne le premier .svg-container
  const svg = document.querySelector(".svg-container");

  if(!svg.classList.contains('visible')){
    // si on veut animer un nouveau svg
    
    svg.classList.add('visible');

    const paths = svg.querySelectorAll('path');
    paths.forEach(function(path){
      const length = path.getTotalLength();
      // dash size
      path.style.strokeDasharray = length;
      // dash offset
      path.style.strokeDashoffset = length;
      // durée (grace à un attribut dédié sur le path)
      const duration = path.getAttribute('data-duration') + "ms";
      if(duration) path.style.animationDuration = duration; 
      // délai (grace à un attribut dédié sur le path)
      const delay = path.getAttribute('data-delay') + "ms";
      if(delay) path.style.animationDelay = delay;
      // anime le tracé
      path.classList.add('animated');
    })

   
  } else {
    // si on veut supprimer le svg en cours
    svg.parentNode.removeChild(svg);
  }

}

document.addEventListener('keydown', function(event){
    switch (event.key) {
      case "p":
        bingo();
        break;
    }
}, false)