const articles = document.querySelectorAll('article');
const a = Array.from(articles);

function sizeArticles(){
  const index = a.indexOf(a.find(e => e.matches('.open')));
  const open = document.querySelector('article.open');
  const next = open.nextElementSibling;
  const prev = open.previousElementSibling;
  articles.forEach((article,idx) => {
    article.classList.remove("next","prev","lastprev","right","left");
    article.classList.add( idx>index ? "right" : "left");
  })
  if(next){
    next.classList.add("next")
  } else {
    const prevprev = prev.previousElementSibling;
    if(prevprev){
      prev.classList.add("lastprev");
      prevprev.classList.add("lastprev");
    }
  }
  if(prev){
    prev.classList.add("prev")
  } 

} 

sizeArticles();

articles.forEach(article => {
  article.onclick = () => {
    if(!article.matches('.open')){
      document.querySelector('article.open').classList.remove('open');
      article.classList.add('open');
      sizeArticles();
    }
  }
})