// initialisation
var wrappers = document.querySelectorAll('.wrapper');

// pour chaque wrapper:
wrappers.forEach(element => {
  // on mesure la taille de l’élément .content
  var scrollwidth = element.querySelector('.content').clientWidth - window.innerWidth;
  // on la stocke dans l’élément
  element.dataset.width = scrollwidth;
  if(element.matches('.revert')){
    element.scrollLeft = scrollwidth;
  } else {
    element.scrollLeft = 0;
  }
  element.addEventListener('wheel', horizontalWheel, true);
});


function horizontalWheel(e) {
  e.preventDefault();
  
  // on bouge l’élément au scroll
  this.scrollLeft += e.deltaY;

  // l’élément qui reçoit l’évènement scroll (this) 
  // détermine le “pourcentage” de scroll pour les autres éléments
  var percent = 0;
  // on lit la largeur stockée dans l’élément
  var scrollWidth = this.dataset.width;
  // selon que l’on doive soustraire ou ajouter au scrollLeft 
  // (si l’élément a la class revert ou pas)
  // on détermine le pourcentage de scroll
  if(this.matches('.revert')){
    percent = (scrollWidth - this.scrollLeft) / scrollWidth;
  } else {    
    percent =  this.scrollLeft / scrollWidth;
  }
  
  // pour chaque élément:
  wrappers.forEach(element => {
    // on lit la largeur stockée dans l’élément
    var myScrollWidth = element.dataset.width;
    // si ce n’est pas l’élément qui reçoit le scroll (on l’a déjà fait bouger)
    if (element != this) {
      if(element.matches('.revert')){
        element.scrollLeft = myScrollWidth - myScrollWidth * percent;
      } else {
        element.scrollLeft = myScrollWidth * percent;
      } 
    } 
  });
}