const numDivs = 20;

const GUTTER = 10; // 10px entre les éléments

function getRandomSize() {
  return Math.floor(Math.random() * (150 - 50 + 1)) + 50;
}

function checkCollision(x, y, divWidth, divHeight, positions) {
  const checkX = x - GUTTER;
  const checkY = y - GUTTER;
  const checkWidth = divWidth + (GUTTER * 2);
  const checkHeight = divHeight + (GUTTER * 2);

  for (const pos of positions) {
    if (checkX < pos.x + pos.width + GUTTER &&
      checkX + checkWidth > pos.x - GUTTER &&
      checkY < pos.y + pos.height + GUTTER &&
      checkY + checkHeight > pos.y - GUTTER) {
      return true;
    }
  }
  return false;
}

function getRandomPosition(divWidth, divHeight) {
  const viewportWidth = window.innerWidth - divWidth;
  const viewportHeight = window.innerHeight - divHeight;

  return {
    x: GUTTER + Math.random() * (viewportWidth - GUTTER * 2),
    y: GUTTER + Math.random() * (viewportHeight - GUTTER * 2)
  };
}

function distributeElements() {
  const divs = document.querySelectorAll('.floating-div');
  const positions = [];
  const maxAttempts = 50;

  divs.forEach(div => {
    // Enlève la class overlapping (qui a pu être attribuée avant un redimensionnement de fenêtre)
    div.classList.remove('overlapping');

    // Les dimensions sont différentes, spécifiques à chaque div
    const rect = div.getBoundingClientRect();
    const divWidth = rect.width;
    const divHeight = rect.height;

    // Cherche une position non utilisée
    let pos;
    let isOverlapping = true;
    let attempts = 0;

    while (attempts < maxAttempts) {
      pos = getRandomPosition(divWidth, divHeight);
      if (!checkCollision(pos.x, pos.y, divWidth, divHeight, positions)) {
        isOverlapping = false;
        break;
      }
      attempts++;
    }

    // Si l’on ne trouve pas de position “libre” après 50 tentatives, tant pis
    // On ajoute la class “overlapping”
    if (isOverlapping) {
      div.classList.add('overlapping');
    }

    // Enregistre la position 
    positions.push({
      x: pos.x,
      y: pos.y,
      width: divWidth,
      height: divHeight
    });
    // Positionne l’élément
    div.style.transform = `translate(${pos.x}px, ${pos.y}px)`;
  });
}

// Crée les div (ils pourraient être déjà dans le HTML)
for (let i = 0; i < numDivs; i++) {
  const div = document.createElement('div');
  div.className = 'floating-div';
  div.textContent = i + 1;
  div.style.width = `${Math.floor(50 + Math.random() * 100)}px`;
  div.style.height = `${Math.floor(50 + Math.random() * 100)}px`;
  document.body.appendChild(div);
}

// Distribution initiale
distributeElements();

// Redistribue au redimensionnement
// (pour plus d’efficacité, on “debounce” l’évènement resize)
let resizeTimeout;
window.addEventListener('resize', () => {
  clearTimeout(resizeTimeout);
  resizeTimeout = setTimeout(distributeElements, 100);
});