const numDivs = 20;

const pairs = [
	{ id: 1, pairId: "lelio" }, 
	{ id: 2, pairId: "gus" }, 
	{ id: 3, pairId: "nancy" }, 
	{ id: 4, pairId: "mimi" },
	{ id: 5, pairId: "nancy" },
	{ id: 6, pairId: "mimi" },
	{ id: 7, pairId: "lelio" },
	{ id: 8, pairId: "gus" },
	{ id: 9, pairId: "mirtille" },
	{ id: 10, pairId: "mirtille" },
	{ id: 11, pairId: "gontran" },
	{ id: 12, pairId: "enzo" },
	{ id: 13, pairId: "enzo" },
	{ id: 14, pairId: "gontran" }
]

// Mélange les paires
pairs.sort(() => Math.random() - 0.5);

const GUTTER = 10; // 10px entre les éléments

function getRandomSize() {
  return Math.floor(Math.random() * (150 - 50 + 1)) + 50;
}

function checkCollision(x, y, divWidth, divHeight, positions) {
  const checkX = x - GUTTER;
  const checkY = y - GUTTER;
  const checkWidth = divWidth + (GUTTER * 2);
  const checkHeight = divHeight + (GUTTER * 2);

  for (const pos of positions) {
    if (checkX < pos.x + pos.width + GUTTER &&
      checkX + checkWidth > pos.x - GUTTER &&
      checkY < pos.y + pos.height + GUTTER &&
      checkY + checkHeight > pos.y - GUTTER) {
      return true;
    }
  }
  return false;
}

function getRandomPosition(divWidth, divHeight) {
  const viewportWidth = window.innerWidth - divWidth;
  const viewportHeight = window.innerHeight - divHeight;

  return {
    x: GUTTER + Math.random() * (viewportWidth - GUTTER * 2),
    y: GUTTER + Math.random() * (viewportHeight - GUTTER * 2)
  };
}

function distributeElements() {
  const divs = document.querySelectorAll('.floating-div');
  const positions = [];
  const maxAttempts = 50;

  divs.forEach(div => {
    // Enlève la class overlapping (qui a pu être attribuée avant un redimensionnement de fenêtre)
    div.classList.remove('overlapping');

    // Les dimensions sont différentes, spécifiques à chaque div
    const rect = div.getBoundingClientRect();
    const divWidth = rect.width;
    const divHeight = rect.height;

    // Cherche une position non utilisée
    let pos;
    let isOverlapping = true;
    let attempts = 0;

    while (attempts < maxAttempts) {
      pos = getRandomPosition(divWidth, divHeight);
      if (!checkCollision(pos.x, pos.y, divWidth, divHeight, positions)) {
        isOverlapping = false;
        break;
      }
      attempts++;
    }

    // Si l’on ne trouve pas de position “libre” après 50 tentatives, tant pis
    // On ajoute la class “overlapping”
    if (isOverlapping) {
      div.classList.add('overlapping');
    }

    // Enregistre la position 
    positions.push({
      x: pos.x,
      y: pos.y,
      width: divWidth,
      height: divHeight
    });
    // Positionne l’élément
    div.style.transform = `translate(${pos.x}px, ${pos.y}px)`;
  });
}

// Variables de jeu
var guess1 = null;
var guess2 = null;
var count = 0;
var lockBoard = false; // Bloque les clics pendant les animations

// Crée les div
pairs.forEach((p, index) => {
  const div = document.createElement('div');
  div.className = 'floating-div';
  div.innerHTML = `<span>${p.pairId}</span>`;
  div.style.width = `${Math.floor(50 + Math.random() * 100)}px`;
  div.style.height = `${Math.floor(50 + Math.random() * 100)}px`;
  div.dataset.index = index
  div.dataset.pairId = p.pairId
  document.body.appendChild(div);

  // Gestion des clics sur les cartes
  div.addEventListener("click", (e) => {
    if (lockBoard) return; // Bloquer les clics pendant l'attente
    if (!div.classList.contains('revealed')) {
      count++;
      div.classList.add('revealed')

      if (count === 1) {
        // Première carte sélectionnée
        guess1 = {
          element: div,
          pairId: div.dataset.pairId
        };
        console.log("Première carte choisie :", guess1); // Débogage
      } else if (count === 2) {
        // Deuxième carte sélectionnée
        guess2 = {
          element: div,
          pairId: div.dataset.pairId
        };
        console.log("Deuxième carte choisie :", guess2); // Débogage

        // Bloquer temporairement les clics
        lockBoard = true;

        // Vérification des correspondances
        if (guess1 && guess2 && guess1.pairId === guess2.pairId) {
          console.log("Match trouvé !");
          guess1.element.classList.add("match");
          guess2.element.classList.add("match");

          // Réinitialisation des guesses
          resetGuesses();
        } else {
          console.log("Pas de correspondance.");
          setTimeout(() => {
            if (guess1 && guess2) {
              guess1.element.classList.remove("revealed");
              guess2.element.classList.remove("revealed");
            }
            // Réinitialisation des guesses
            resetGuesses();
          }, 1000); // Attendre 1 seconde avant de masquer les cartes
        }
      }
    }
  });
})



// Distribution initiale
distributeElements();

// Redistribue au redimensionnement
// (pour plus d’efficacité, on “debounce” l’évènement resize)
let resizeTimeout;
window.addEventListener('resize', () => {
  clearTimeout(resizeTimeout);
  resizeTimeout = setTimeout(distributeElements, 100);
});


// Fonction pour réinitialiser les guesses et débloquer le plateau
function resetGuesses() {
	count = 0;
	guess1 = null;
	guess2 = null;
	lockBoard = false;
	console.log("Réinitialisation des guesses."); // Débogage
}