const gap = 5;
const nb = 8;
function resize(){
  let size = (Math.min(window.innerHeight, window.innerWidth) - gap * (nb - 1)) / nb;
  document.body.style.setProperty('--w', size + "px");
  document.body.style.setProperty('--gap', gap + "px");
  document.body.style.setProperty('--nb', nb);
}
window.addEventListener('resize', resize)
resize();

for(let i = 0; i < nb * nb; i++){
  const span = document.createElement('span');
  const div = document.createElement('div');  
  const delay = Math.round(Math.random() * 4) * -1000;
  const rot = Math.round( Math.random() * 4) * 90;
  const scale = Math.random() > 0.5 ? "1" :" -1";
  span.style.top = Math.random() > 0.5 ? "calc(var(--w) * -1 )" : "";
  span.style.left = Math.random() > 0.5 ? "calc(var(--w) * -1)" : "";
  span.style.animation = `3s linear ${delay}ms infinite rotate`;
  div.style.transform = `scale(${scale})) rotate(${rot}deg) `;
  div.appendChild(span);
  document.body.appendChild(div);
}