const svg = document.querySelector("svg")
function broadcast(type, button, value) {
  let svg_part_id = svgIds[button];
  
  if(type=="button" ){
    let svgbutton = svg.querySelector(svg_part_id);
    if (value == 1) {
      svgbutton.classList.add("active")
    }
    if(button=="A" && value == 1){
      alert("Salut Loubna")
    }
    if (value == 0) {
      svgbutton.classList.remove("active")
    }
  }
  if (type == "axis") {
    // “real” axis are only joystick
    const isJoystick = Array.isArray(svg_part_id);
    if (isJoystick) {
      svgaxis = value > 0 ? svg.querySelector(svg_part_id[0]) : svg.querySelector(svg_part_id[1]);
      if (value >= 0.001 || value <= -0.001) {
        svgaxis.classList.add("active")
      }
      if (value < 0.001 && value > -0.001) {
        svg_part_id.forEach(id => {
          svg.querySelector(id).classList.remove("active")
        });
      }
    } else {
      // R2 & L2 buttons
      let svgaxis = svg.querySelector(svg_part_id);
      if (value >= 0.001 ) {
        svgaxis.classList.add("active")
      } else {
        svgaxis.classList.remove("active")
      }
    }    
  }  
}

svgIds = {
  "L":"#l",
  "L2":"#l2",
  "R2":"#r2",
  "R":"#r",
  "Pad":"#pad",
  "X":"#x",
  "B":"#b",
  "A":"#a",
  "Y":"#y",
  "Home":"#home",
  "Select":"#select",
  "Start":"#start",
  "Joystick L ←→": ["#joystick-l-right", "#joystick-l-left"],
  "Joystick L ↑↓": ["#joystick-l-down", "#joystick-l-up"],
  "L3":"#l3",
  "Joystick R ←→": ["#joystick-r-right", "#joystick-r-left"],
  "Joystick R ↑↓": ["#joystick-r-down", "#joystick-r-up"],
  "R3":"#r3",
  "Left":"#left",
  "Down":"#down",
  "Right":"#right",
  "Up":"#up",
}


/*
 * Gamepad API Test
 * Written in 2013 by Ted Mielczarek <ted@mielczarek.org>
 *
 * To the extent possible under law, the author(s) have dedicated all copyright and related and neighboring rights to this software to the public domain worldwide. This software is distributed without any warranty.
 *
 * You should have received a copy of the CC0 Public Domain Dedication along with this software. If not, see <http://creativecommons.org/publicdomain/zero/1.0/>.
 */
var haveEvents = 'GamepadEvent' in window;
var controllers = {};
var rAF = window.requestAnimationFrame;

function connecthandler(e) {
  addgamepad(e.gamepad);
}
const buttonsMap = {
  "b0": "B",
  "b1": "A",
  "b2": "X",
  "b3": "Y",
  "b4": "L",
  "b5": "R",
  "b8": "Select",
  "b9": "Start",
  "b10": "L3",
  "b11": "R3",
  "b12": "Up",
  "b13": "Down",
  "b14": "Left",
  "b15": "Right",
  "b16": "Home",
  "a0": "Joystick L ←→",
  "a1": "Joystick L ↑↓",
  "a2": "Joystick R ←→",
  "a3": "Joystick R ↑↓",
  "a4": "L2",
  "a5": "R2",
}

function addgamepad(gamepad) {
  controllers[gamepad.index] = gamepad;
  var d = document.createElement("div");
  d.setAttribute("id", "controller" + gamepad.index);
  var t = document.createElement("h1");
  t.appendChild(document.createTextNode("gamepad: " + gamepad.id));
  d.appendChild(t);
  var b = document.createElement("div");
  b.className = "buttons";
  for (var i=0; i<gamepad.buttons.length; i++) {
    var e = document.createElement("span");
    e.className = "button";
    e.id = "b" + i;
    e.innerHTML = buttonsMap[e.id] ?? i;
    b.appendChild(e);
  }
  d.appendChild(b);
  var a = document.createElement("div");
  a.className = "axes";
  for (i = 0; i < gamepad.axes.length; i++) {
    var p = document.createElement('p');
    var e = document.createElement("meter");
    var l = document.createElement("label");
    e.className = "axis";
    e.id = "a" + i;
    e.setAttribute("min", "-1");
    e.setAttribute("max", "1");
    e.setAttribute("value", "0");
    l.innerHTML = buttonsMap[e.id] ?? e.id;
    p.appendChild(l)
    p.appendChild(e);
    a.appendChild(p)
  }
  
  d.appendChild(a);
  document.querySelector("h2").style.display = "none";
  document.body.appendChild(d);
  rAF(updateStatus);
}

function disconnecthandler(e) {
  removegamepad(e.gamepad);
}

function removegamepad(gamepad) {
  var d = document.getElementById("controller" + gamepad.index);
  document.body.removeChild(d);
  delete controllers[gamepad.index];
}

function updateStatus() {
  scangamepads();
  for (j in controllers) {
    var controller = controllers[j];
    var d = document.getElementById("controller" + j);
    var buttons = d.getElementsByClassName("button");
    for (var i=0; i<controller.buttons.length; i++) {
      var b = buttons[i];
      var val = controller.buttons[i];
      var pressed = val == 1.0;
      var touched = false;
      if (typeof(val) == "object") {
        pressed = val.pressed;
        if ('touched' in val) {
          touched = val.touched;
        }
        val = val.value;
      }
      var pct = Math.round(val * 100) + "%";
      b.style.backgroundSize = pct + " " + pct;
      b.className = "button";
      const id = buttonsMap[b.id] ?? null;
      if(id) broadcast("button", id, 0)
      if (pressed) {
        b.className += " pressed";
        broadcast("button",id, 1)
      }
      if (touched) {
        b.className += " touched";
        broadcast("button",id, 1)
      }
    }

    var axes = d.getElementsByClassName("axis");
    for (var i=0; i<controller.axes.length; i++) {
      var a = axes[i];
      a.innerHTML = i + ": " + controller.axes[i].toFixed(4);
      a.setAttribute("value", controller.axes[i]);
      broadcast("axis", buttonsMap[a.id], controller.axes[i])
    }
  }
  rAF(updateStatus);
}

function scangamepads() {
  var gamepads = navigator.getGamepads ? navigator.getGamepads() : (navigator.webkitGetGamepads ? navigator.webkitGetGamepads() : []);
  for (var i = 0; i < gamepads.length; i++) {
    if (gamepads[i] && (gamepads[i].index in controllers)) {
      controllers[gamepads[i].index] = gamepads[i];
    }
  }
}

if (haveEvents) {
  window.addEventListener("gamepadconnected", connecthandler);
  window.addEventListener("gamepaddisconnected", disconnecthandler);
} else {
  setInterval(scangamepads, 500);
}
