// valeur de base 
const width = 100,
  height = 200;

// positionnement du premier point de la première grille
let x = 20,
  y = 20;

// chaîne de caractère
const str = "mondeallercinq"

// dictionnaire des valeur de la grille de création de caractère
const pos = {
  a: [0, 0],
  b: [50, 0],
  c: [100, 0],
  d: [0, 20],
  e: [50, 20],
  f: [100, 20],
  g: [0, 40],
  h: [50, 40],
  i: [100, 40],
  j: [0, 60],
  k: [50, 60],
  l: [100, 60],
  m: [0, 80],
  n: [50, 80],
  o: [100, 80],
  p: [0, 100],
  q: [50, 100],
  r: [100, 100]
}
let cnv=null;
function setup() {
  
  cnv = createCanvas(800, 1600);

  background(220);
  fill(0)
    noStroke()
 
 // split permet d'isoler chaque élément de la chaîne de caractère
  const letters = str.split("")
  for(letter of letters){
    drawGrid()
    stroke(0)
    strokeWeight(4)
    drawLetter(letter)
    changeX()
    noStroke()
  }
  

}

function drawGrid() {
  for (const [k, v] of  Object.entries(pos)) {
    let [p1, p2] = getPos(v)
    //ellipse(p1, p2, 4, 4)
    textSize(8);
    text(k, p1, p2)
  }
}

function getPos(list_of_percentages) {
  let posx = x + width * list_of_percentages[0] / 100;
  let posy = y + height * list_of_percentages[1] / 100;
  //posx = posx + Math.random() * 8 - 4
  //posy = posy + Math.random() * 8 - 4
  return [posx, posy]
}

// cette fonction permet de tracer les ligne qui relie les point de la grille donc créée les lettres une à une mais de manière structuré 
function drawLetter(letter){
  if(letter=="b") drawLines("efoihki")
  if(letter=="o") drawLines("geilnjg")
  if(letter=="a") drawLines("dfoigmi")
  if(letter=="e") drawLines("giegml")
  if(letter=="f") drawLines("cbdmjhg")
  if(letter=="c") drawLines("")
  if(letter=="u") drawLines("djnlif")
  if(letter=="s") drawLines("ieglnj")
  if(letter=="d") drawLines("coiegjnl")
  if(letter=="m") drawLines("dmgenhfo")
  if(letter=="n") drawLines("dmgeio")
  if(letter=="l") drawLines("abnmo")
  if(letter=="r") drawLines("dmgef")
  if(letter=="i") {drawLines("denmo"); drawPoint("b")}
}

function changeX(){
 //.      interlettrage
  x = x + width * 0.6 + width;
  if(x > 800 - width - 40 ){
    x = 20;
   //.               interlignage
    y = y + height + width * 0.6
  }
}


function drawLines(code) {

  const codes = code.split("")

  for(let i = 0; i < codes.length; i++) {

    const start = codes[i], 
      end = i < codes.length ? codes[i + 1] : codes[i];

    let [start_x, start_y] = getPos(pos[start])
    let [end_x, end_y] = getPos(pos[end] || pos[start])
    line(start_x, start_y, end_x, end_y) 

  
  }
  
}

function drawPoint(letter) {
  let [a, b] = getPos(pos[letter]); 
  ellipse(a, b, 10, 10)
}



function keyPressed() {
   if (key === 's') {
    let now = new Date().toISOString();
 save(cnv, `typo-${now}.png`);
  } 
}