function getRandomInt(min, max) {
    return Math.floor(Math.random() * (max - min + 1)) + min;
}

function getRandomColor() {
    const colors = ['#fbaf00ff', '#ffd639ff', '#ffa3afff', '#007cbeff', '#00af54ff'];
    return colors[getRandomInt(0, colors.length - 1)];
}

function drawLine(x1, y1, x2, y2, width, color) {
    const line = document.createElementNS("http://www.w3.org/2000/svg", "line");
    line.setAttribute("x1", x1);
    line.setAttribute("y1", y1);
    line.setAttribute("x2", x2);
    line.setAttribute("y2", y2);
    line.setAttribute("stroke", color);
    line.setAttribute("stroke-width", width);
    return line;
}

function drawRect(x, y, width, height, fill) {
    const rect = document.createElementNS("http://www.w3.org/2000/svg", "rect");
    rect.setAttribute("x", x);
    rect.setAttribute("y", y);
    rect.setAttribute("width", width);
    rect.setAttribute("height", height);
    rect.setAttribute("fill", fill);
    return rect;
}
function calculateRotatedWidth(originalWidth, originalHeight, angleInDegrees) {
    // Convert angle to radians
    const angleInRadians = angleInDegrees * Math.PI / 180;

    // Calculate the new width (fucking x-axis projection of rotated rectangle)
    const rotatedWidth = Math.abs(originalWidth * Math.cos(angleInRadians)) + Math.abs(originalHeight * Math.sin(angleInRadians));

    return rotatedWidth;
}
function createBook(x, maxHeight, color, rotation = 0) {
    const padding = 2;
    const height = getRandomInt(120, maxHeight - padding);
    const width = getRandomInt(20, 40);
    let numPages = getRandomInt(4, 8);
    const pageWidth = getRandomInt(1, 3);
    const coverWidth = getRandomInt(2, 4);
    
    let spaceBetweenPagesAndCovers = (width - coverWidth * 2 - numPages * pageWidth) / (numPages + 1);
    while(spaceBetweenPagesAndCovers < 1){
        numPages = numPages - 1;
        spaceBetweenPagesAndCovers = (width - coverWidth * 2 - numPages * pageWidth) / (numPages + 1);
    }
    

    x += padding + coverWidth / 2;

    const yOffset = maxHeight - height;

    const bookGroup = document.createElementNS("http://www.w3.org/2000/svg", "g");

    // Calculate the rotation's horizontal shift
    const radians = rotation * Math.PI / 180;
    let horizontalShift = width * Math.cos(radians) + height * Math.sin(radians);
    horizontalShift = calculateRotatedWidth(width + padding * 2, height+ padding , rotation)
    x += (horizontalShift - width) / 2


    // Determine the rotation center
    let rotateX, rotateY = maxHeight;
    if (rotation < 0) {
        // Rotate around the bottom left point
        rotateX = x;
    } else {
        // Rotate around the bottom right point
        rotateX = x + width;
    }
    bookGroup.setAttribute("transform", `rotate(${rotation}, ${rotateX}, ${rotateY})`);

    // Draw the white rectangle as the book background (with 5px “padding”)
    //bookGroup.appendChild(drawRect(x - padding, yOffset - padding, width + padding * 2, height + padding * 2, 'transparent'));

    // Draw the white rectangle as the book background
    bookGroup.appendChild(drawRect(x, yOffset, width, height, 'white'));
    
    // Create back (left) cover
    bookGroup.appendChild(drawLine(x + coverWidth / 2, yOffset, x + coverWidth / 2, yOffset + height, coverWidth, color));

    // Create front (right) cover
    bookGroup.appendChild(drawLine(x + width - coverWidth / 2, yOffset, x + width - coverWidth / 2, yOffset + height, coverWidth, color));

    

    // Create pages
    let currentX = x + coverWidth + spaceBetweenPagesAndCovers;
    //currentX = parseFloat(currentX).toFixed(2)
    for (let i = 0; i < numPages; i++) {
        bookGroup.appendChild(drawLine(currentX + pageWidth / 2, yOffset, currentX + pageWidth / 2, yOffset + height, pageWidth, color));
        currentX += pageWidth + spaceBetweenPagesAndCovers;
    }


    let text = document.createElementNS('http://www.w3.org/2000/svg', 'text')
    text.textContent = spaceBetweenPagesAndCovers
    //bookGroup.appendChild(text)
    text.setAttribute("fill", "black")
    text.setAttribute("x", currentX)
    text.setAttribute("y", 40)

    return { bookGroup, width, horizontalShift };
}

function generateBooks() {
    const svg = document.createElementNS("http://www.w3.org/2000/svg","svg");
    document.body.appendChild(svg)
    svg.setAttribute("viewBox", "0 0 1200 200")
    let currentX = 0;
    let bookCounter = 0;
    const maxHeight = 160;

    while (currentX < 1000) {
        //const color = getRandomColor();
        const color ="#000"
        // Rotate one out of every four books
        let rotation = (Math.random() > 0.6 && currentX != 0) ? getRandomInt(-15, 15) : 0;
        rotation = rotation.toFixed(2)
        //rotation = 0;
        const { bookGroup, width, horizontalShift} = createBook(currentX, maxHeight, color, rotation);
        svg.appendChild(bookGroup);

        if (rotation === 0) {
            // Update currentX for the next book with random spacing
            currentX += width + getRandomInt(10, 20);
        } else {
            // Adjust currentX for the next book based on the rotation shift
            currentX += horizontalShift;
        }

        bookCounter++;
    }
}

// Run the function to generate books
for(let i= 0; i< 10; i++) {
    generateBooks();
}
