

const textInput = document.querySelector('#textInput');

window.addEventListener('load', (e) => {
    const recorded_text = localStorage.getItem("recorded_text");
    textInput.focus();
    if(recorded_text){
        console.log(recorded_text)
        textInput.textContent = recorded_text
    }
})


textInput.addEventListener("input", function() {
    storeContent(textInput.textContent)
}, false);


function storeContent(text){
    console.log(text)
    localStorage.setItem('recorded_text', text)
}


/*

// multiple listeners

const listeners = ["dblclick", "click"];
for (const l of listeners) {
    document.body.addEventListener(l, (e) => {
        //console.log('triggered', e);
    })
}

// random audio
const audio = document.querySelector('#audio');
const listedesaudiospossibles = [
    "fichier2.mp3",
    "fichier3.mp3",
    "fichier4.mp3",
]
document.body.addEventListener('click', (e) => {
    const src = "mp3/" + listedesaudiospossibles[Math.floor(Math.random() * listedesaudiospossibles.length)];
    console.log(src)
    audio.src = src
})
*/