const images = document.querySelectorAll('img'); // toutes les images
const infos_element = document.querySelector('#infos'); // élément pour afficher les infos
const score_element = document.querySelector('#score'); // élément pour afficher les infos
const timer = document.querySelector('#timer'); // élément pour afficher le temps
let score = 0; // score initial

// on enregistre le moment du chargement de la page
const start = Date.now();

// toutes les secondes (1000 millisecondes)
// setInterval détermine une fonction exécutée régulièrement
var comptearebours = setInterval( () => {
  // on calcule la différence entre maintenant et le moment du démarrage
  const millisecondes = Date.now() - start;
  const reste = 20 - Math.floor(millisecondes / 1000); 
  timer.textContent = reste;
  // si le temps est dépassé…
  if(reste <= 0 ){
    // on affiche qu’on a perdu
    infos_element.textContent = "Perdu :(";
    document.body.classList.add("lost");
    // on arrête le compte à rebours
    clearTimeout(comptearebours);
  }
}, 1000);

// pour chaque image
images.forEach(function(image){
  image.onclick = () => {
    // on ajoute 1 au score actuel 
    score += 1;
    // on modifie le contenu textuel de l’élément #score
    score_element.textContent = score;
    // si le score est (supérieur ou) égal à 20
    if(score >= 20){
      // on affiche qu’on a gagné
      infos_element.textContent = "Gagné :)";
      document.body.classList.add("win");
      // on arrête le compte à rebours
      clearTimeout(comptearebours);
    }
  }
})