var processFootNotesToSideNotes = function processFootNotesToSideNotes(opts){
    'use strict';
    var selector = opts.rootSel+' [id^='+ opts.footNoteAnchorIdStart+']';
    var footNotesAnchors = document.querySelectorAll(selector),
        sidenotes = [],
        i = 1; //Note numbering
//    console.log(footNotesAnchors)
  

    //Each footnote
    Array.prototype.forEach.call(footNotesAnchors,function(note){ 

        var small = document.createElement('small');
        small.classList.add('sidenote');
        small.setAttribute('data-ref',i);
      
        var anchor = note.querySelector("a");
        var id = anchor.getAttribute('href').replace('#', '');
        var target = document.getElementById(id);

        small.innerHTML = target.innerHTML;
        
        var sidenote = {};
        sidenote.id = id;
        sidenote.anchor = anchor;
        sidenote.node = small;
        sidenote.num = i;
        sidenotes.push(sidenote);
        i++;

        //remove the original footnote
        note.parentNode.removeChild(note);
    });

    //remove the footNotes container
    var footNotesConts = document.querySelectorAll(opts.rootSel+' '+opts.footNotesContainerSel);
    Array.prototype.forEach.call(footNotesConts,function(footNoteCont){
        footNoteCont.parentNode.removeChild(footNoteCont);
    });

    return sidenotes;
};


var initialize = function initialize(options){
    'use strict';
    var opts = options || {
        rootSel:'.wrapper',
        footNotesContainerSel:'.footnotes',
        footNotesSel:'ol li',
        footNoteIdPattern:'fn:',
        footNoteAnchorIdStart:'fnref',
        sideNoteClass:'sidenote'
    };

    var renderSideNotes = function renderSideNotes(sidenotes){
        //place sidenotes into the DOM, just before their anchor ref.
        //remove any previously rendered infocards and/or hide original footnotes
        sidenotes.forEach(function(note){
            console.log(note);
            //get the global container

            var container = note.anchor.parentElement.parentElement;
            console.log(container);
            /* big screens */
            //in the container, insert the note before the anchor parent
            container.insertBefore(note.node, note.anchor.parentElement);
        });
    };

    
    var notes = processFootNotesToSideNotes(opts);
//    console.dir(notes);
    renderSideNotes(notes);


};

//module.exports = processFootNotes;

initialize({
  rootSel:'.wrapper',
  footNotesContainerSel:'.footnotes', //base container for the footnotes to transform into sidenotes
  footNotesSel:'ol li', //selector for the footnotes
  footNoteIdPattern:'fn:', //existing footNotes ID prefix
  footNoteAnchorIdStart:'fnref', //ID prefix for the anchors in the main content, linking to notes.
  sideNoteClass:'sidenote' //optional : this class will be used for the generated sidenotes
})