
// chaîne de caractères de test
let str = "zut ! je crois que le chien sambuca préfère le whisky revigorant au doux porto"
// Si la chaîne est vide, tous les caractères seront dessinés
str = "a"

// dessins de lettres
const glyphs = {
  "a": ["dfomjho"],
  "b": ["amoiej"],
  "c": ["iejmo"],
  "d": ["comgel"],
  "e": ["jliejmo"],
  "f": ["fbnhig"],
  "g": ["profdjni"],
  "h": ["amjeio"],
  "i": ["ienmo", "b"],
  "j": ["jqei", "b"],
  "k": ["amjfho"],
  "l": ["dbno"],
  "o": ["iegjmoi"],
  "m": ["dmjenkfo"],
  "n": ["dmjeio"],
  "p": ["pdflng"],
  "q": ["rfdjni"],
  "r": ["dmjei"],
  "s": ["feglnm"],
  "t": ["bhohedf"],
  "u": ["djnlif"],
  "v": ["dgnif"],
  "w": ["dmhof"],
  "x": ["dglo+fijm"],
  "y": ["djnifrp"],
  "z": ["gdfmo"],

  "&": ["oacgmi"],

  "0": ["acomamc"],
  "1": ["gbnmo"],
  "2": ["omfbg"],
  "3": ["achilom"],
  "4": ["aghfco"],
  "5": ["cagilnm"],
  "6": ["cadjnoig"],
  "7": ["abcfhm+gi"],
  "8": ["acfhgmoihda"],
  "9": ["cagicinm"],

  ".": ["","n"],
  ",": ["knp"],
  "?": ["dacfhk","n"],
  "!": ["bk" , "n"],
  "-": ["gi"],
  ":": ["", "hn"],
  "[": ["cbno"],
  "]": ["abnm"],
  "«": ["ae+bf"],
  "»": ["ce+bd"],
  "(": ["bdjn"],
  ")": ["bfln"],
  "'": ["be"],
  "+": ["ek+gi"],
  "/": ["cm"],
  ";": ["knp", "h"],
  "=": ["gi+jl"],
  "{": ["cbegkno"],
  "}": ["abeiknm"],
  "*": ["ai+gc+bh+df"],
  ">": ["glm"],
  "<": ["ijo"],
  "_": ["mo"],
  "$": ["fbdlnj+bn"],

  "è": ["jliejmo+af"],
  "é": ["jliejmo+dc"],
  "ë": ["jliejmo", "ac"],
  "ê": ["jliejmo+dbf"],

  "à": ["dfomjho+af"],

  "ù": ["djnlif+af"],

  "ç": ["iejmonqp"],

  "ï": ["ienmo", "ac"],
  "î": ["ienmo+dbf"],

  "A": ["gi+mgbio"],
  "B": ["mabcfhghlom"],
  "C": ["cbdjno"],
  "D": ["mabflnm"],
  "E": ["caghgmo"],
  "F": ["camgh"],
  "G": ["cbdjnoih"],
  "H": ["amgiioc"],
  "I": ["acbnmo"],
  "J": ["acoqp"],
  "K": ["amcho"],
  "L": ["amo"],
  "M": ["mahco"],
  "N": ["maoc"],
  "O": ["camoc"],
  "P": ["mabfikj"],
  "Q": ["camoconrj"],
  "R": ["mabcfihgho"],
  "S": ["fbdlnj"],
  "T": ["nbac"],
  "U": ["ajnlc"],
  "V": ["anc"],
  "W": ["amhoc"],
  "X": ["aohcm"],
  "Y": ["ahnhc"],
  "Z": ["acmo"],

  "É": ["fdghgmo+ec"],
  "È": ["fdghgmo+ea"],
  "Ë": ["fdghgmo", "ac"],
  "Ê": ["fdghgmo+dbf"],
  //"Ê": ["fdghgmo+sbU"],

  "À": ["jl+mgeio+ae"],
  "Â": ["jl+mgeio+dbf"],
}

// valeurs de base
const width = 200, // largeur de chaque lettre
  height = 400, // hauteur de chaque lettre
  stroke_weight = 20, // épaisseur du trait
  dot_weight = stroke_weight / 2 * 1.4, // épaisseur des points
  svg_width = 700; // largeur du plan de travail
  svg_height = 1200, // hauteur du plan de travail
  drawMode = "lines", // lines | polylines ?
  linecap = "round", // butt | round | square ?
  linejoin = "bevel"; // arcs | bevel | miter | miter-clip | round ?

let padding = 20; // espace entre la boite englobante et la lettre


// crée le svg principal (plan de travail)
const svg = document.createElementNS('http://www.w3.org/2000/svg', "svg");
document.body.appendChild(svg)
svg.setAttribute("viewBox", `0 0 ${svg_width} ${svg_height}`);

// positionnement du premier point de la première grille
let x = padding,
  y = padding;

// cette fonction permet de tracer les ligne qui relie les point de la grille donc créée les lettres une à une mais de manière structuré
function drawLetter(letter){
  if(letter in glyphs){
    drawLines(letter, glyphs[letter][0], glyphs[letter][1] ?? null )
  }
}

// dictionnaire des valeurs de la grille de création de caractère (en pourcentages)
const pos = {
  a: [0, 0],
  b: [50, 0],
  c: [100, 0],
  d: [0, 20],
  e: [50, 20],
  f: [100, 20],
  g: [0, 40],
  h: [50, 40],
  i: [100, 40],
  j: [0, 60],
  k: [50, 60],
  l: [100, 60],
  m: [0, 80],
  n: [50, 80],
  o: [100, 80],
  p: [0, 100],
  q: [50, 100],
  r: [100, 100],


  //s: [0, 10],
  //t: [50, 10],
  //U: [100, 10],
}

if(str != ""){
  // split permet d'isoler chaque élément de la chaîne de caractère
  const letters = str.split("");
  for(const letter of letters){
    drawGrid();
    drawLetter(letter);
    changeX();
  }
} else {
  padding = stroke_weight * 2;
  // si la chaîne n’est pas vide, on exporte tous les caractères
  Object.keys(glyphs).forEach((glyph) => {
    drawLetter(glyph)
  })
}

//  drawGrid n’est activé que si la chaîne `str` n’est pas vide
function drawGrid() {
  const group = document.createElementNS("http://www.w3.org/2000/svg", "g");
  for (const [k, v] of  Object.entries(pos)) {

    let [center_x, center_y] = getPos(v);

    // text
    const text = document.createElementNS("http://www.w3.org/2000/svg", "text");
    text.textContent = k;
    text.setAttribute('x', center_x);
    text.setAttribute('y', center_y);
    // activer/désactiver grille de lettres ?
    group.appendChild(text)

    const circle = document.createElementNS("http://www.w3.org/2000/svg", "circle");
    circle.setAttribute('r', 2);
    circle.setAttribute('cx', center_x);
    circle.setAttribute('cy', center_y);
    // activer/désactiver grille de points ?
    //group.appendChild(circle)
  }
  svg.appendChild(group)
}

function getPos(list_of_percentages) {
  let posx = x + width * list_of_percentages[0] / 100;
  let posy = y + height * list_of_percentages[1] / 100;
  // Moooar fun ?
  //posx = posx + Math.random() * 200 - 100;
  //posy = posy + Math.random() * 200 - 100;
  return [posx, posy]
}

function changeX(){
  // interlettrage
  x = x + width * 0.6 + width;
  if(x > svg_width - width - padding * 2 ){
    x = padding;
    // interlignage
    y = y + height + width * 0.6
  }
}

function drawLine(x1, y1, x2, y2, width = stroke_weight , color = "black") {
    const line = document.createElementNS("http://www.w3.org/2000/svg", "line");
    line.setAttribute("x1", x1);
    line.setAttribute("y1", y1);
    line.setAttribute("x2", x2);
    line.setAttribute("y2", y2);
    line.setAttribute("stroke", color);
    line.setAttribute("stroke-width", width);
    line.setAttribute("style", `stroke-linecap:${linecap};stroke-linejoin:${linejoin}`)
    return line;
}

function drawPolyline(points, width = stroke_weight, color = "black"){
  const polyline = document.createElementNS("http://www.w3.org/2000/svg", "polyline");
  polyline.setAttribute('points', points)
  polyline.setAttribute("fill", "none");
  polyline.setAttribute("stroke", color);
  polyline.setAttribute("stroke-width", width);
  polyline.setAttribute("style", `stroke-linecap:${linecap};stroke-linejoin:${linejoin}`)
  return polyline;
}

function drawLines(letter, code, dots) {

  const group = document.createElementNS("http://www.w3.org/2000/svg", "g");
  group.setAttribute('id', letter)

  // points
  if(dots){
    const dts = dots.split("");
    dts.forEach((dt) => {
      const circle = document.createElementNS("http://www.w3.org/2000/svg", "circle");
      circle.setAttribute('r', dot_weight);
      let [center_x, center_y] = getPos(pos[dt])
      circle.setAttribute('cx', center_x);
      circle.setAttribute('cy', center_y);
      group.appendChild(circle)
    })
  }

  // découpe `code` au cas où la lettre soit en plusieurs morceaux (délimités par des `+`)
  code = code.split('+');
  for(c of code){
    const codes = c.split("")
    if(codes == "") { break;}

    if(drawMode == "lines"){
      // lines
      for(let i = 0; i < codes.length; i++) {
        const start = codes[i],
          end = i < codes.length ? codes[i + 1] : codes[i];
        let [start_x, start_y] = getPos(pos[start])
        let [end_x, end_y] = getPos(pos[end] || pos[start])
        let line = drawLine(start_x, start_y, end_x, end_y)
        group.appendChild(line)
      }
    } else {
      // polyline
      let points = ""
      for(let i = 0; i < codes.length; i++) {
        const start = codes[i],
          end = i < codes.length ? codes[i + 1] : codes[i];
        let [start_x, start_y] = getPos(pos[start])
        let [end_x, end_y] = getPos(pos[end] || pos[start])
        points += `${start_x},${start_y} ${end_x},${end_y} `
      }
      const polyline = drawPolyline(points )
      group.appendChild(polyline)
    }
  }

  svg.appendChild(group)
}

// save (s)
window.addEventListener('keydown', (e) => {
  if(e.key == "s"){
    copyTextToClipboard(svg.outerHTML)
  }
})

// copy to clipboard
function copyTextToClipboard(text) {
  navigator.clipboard.writeText(text).then(function() {
    console.log('Async: Copying to clipboard was successful!');
  }, function(err) {
    console.error('Async: Could not copy text: ', err);
  });
}
