/* https://beyondloom.com/tools/earmark.html */
/* waveform editor / display */
let mode = 0, wave = [], t = document.getElementById('target')
window.onresize = _ => {
	const w = t.width = t.clientWidth, h = t.height = t.clientHeight, g = t.getContext('2d')
	if (wave.length != w) { let r = []; for (var x = 0; x < w; x++) r[x] = wave[x] || 0.5; wave = r }
	for (let x = 0; x < w; x++) g.fillRect(x, h-wave[x]*h, 1, wave[x]*h)
}
window.onresize()
t.onmousemove = e => {
	if (!mode) return
	for (var x = -5; x <= 5; x++) wave[x + e.clientX] = 1-e.clientY/t.clientHeight
	window.onresize()
}
t.onmouseup   = e => { mode = 0; t.onmousemove(e) }
t.onmousedown = e => { mode = 1; t.onmousemove(e) }
