function getRandomValue(min, max){
    return Math.floor(Math.random() * (max - min +1)) + min;
}

const number = 100;

function generateRandomDivs(count){
    for(let i = 0; i < count; i++) {
        const div = document.createElement("div");
        div.className = "laut";

        if (Math.random() > 0.5) {
            div.textContent = "laut";
        } else {
            div.textContent = "LAUT";
        }
        const variatop = scale(i, [0, number], [100, -50])
        const variasizemin = scale(i, [0, number], [45, 200])
        const variasizemax = scale(i, [0, number], [200, 500])
        div.style.marginLeft = `${getRandomValue(0,100)}%`;
        div.style.marginTop = `${getRandomValue(0,variatop)}%`;
        div.style.top = `${getRandomValue(0,100)}%`;
        div.style.fontSize = `${getRandomValue(variasizemin,variasizemax)}px`;
        document.body.appendChild(div);
    }
}

window.onload = function() {
    window.scrollTo(0,0);
    generateRandomDivs(number);
};

const scale = (inputY, yRange, xRange) => {
  const [xMin, xMax] = xRange;
  const [yMin, yMax] = yRange;

  const percent = (inputY - yMin) / (yMax - yMin);
  const outputX = percent * (xMax - xMin) + xMin;

  return outputX;
};
