function fillViewportWithCircles() {
  // Calculate the number of circles needed for the viewport
  const size = 12; 
  const sizeInPx = window.innerWidth /size; 
  document.body.style.setProperty('--size', sizeInPx)
  const cols = Math.ceil(window.innerWidth / sizeInPx);
  const rows = Math.ceil(window.innerHeight / sizeInPx);

  // Generate circles
  for (let row = 0; row < rows; row++) {
    for (let col = 0; col < cols; col++) {
      let tomato = document.createElement('span');
      tomato.style.zIndex = Math.random() > .5 ? 0 : 1;
      document.body.appendChild(tomato);
      if(Math.random() > .5) {
        let white = document.createElement('em');
        tomato.appendChild(white);
      } 
    }
  }
}


// Call the function to fill the viewport
fillViewportWithCircles();

// Optional: Adjust circles on window resize
window.addEventListener('resize', () => {
  document.body.innerHTML = ''; // Clear existing circles
  fillViewportWithCircles();
});
