function randint(min, max) {
      return Math.floor(Math.random() * (max - min + 1)) + min;
    }
    function shuffle(array) {
      for (let i = array.length - 1; i > 0; i--) {
        let j = Math.floor(Math.random() * (i + 1));
        [array[i], array[j]] = [array[j], array[i]];
      }
    }

    function drawCircles(){
      const colors = ["tomato", "deeppink", "darkorange", "firebrick", "salmon"];
      const cl = [...colors];
      shuffle(cl);
      const d = document.createElement('div');
      d.className = "circles";
      const n = randint(2, 4);
      let old_c = null;
      for(let i = 0; i < n; i++) {
        const c = document.createElement('div');
        c.className = "circle";
        const m = 100 - 100 / n * i;
        console.log(m);
        c.style.setProperty('--s', m )

        c.style.setProperty('--old_c', old_c == null ? cl[0] : old_c)
        old_c =  cl.shift();
        c.style.setProperty('--c', old_c)
        d.appendChild(c);

        c.classList.add( randint(0,100) > 50 ? "trevni" : "invert")

        const sizes = ["full", 'threequarter', 'half', 'quarter'];
        c.classList.add( sizes[ randint(0, sizes.length - 1)] );

        const rotations = [45, 135, 225, 315];
        c.style.setProperty('--rotate', rotations[ randint(0, rotations.length - 1)] + "deg");
    
      } 
      return d;
    }
    // Function to create the grid
    function createGrid(rows, cols, size, gap) {
      const gridContainer = document.createElement('div');
      gridContainer.classList.add('grid-container');
      gridContainer.style.gridGap = `${gap}px`;

      gridContainer.style.gridTemplateColumns = `repeat(${cols}, 1fr)`;
      gridContainer.style.gridTemplateRows = `repeat(${rows}, 1fr)`;
      gridContainer.style.setProperty('--size', size + "px")

      for (let i = 0; i < rows * cols; i++) {
        const gridItem = drawCircles();     
        gridItem.classList.add('grid-item');
        

        gridContainer.appendChild(gridItem);
      }

      return gridContainer;
    }

    // Function to calculate the number of rows and columns
    function calculateGridSize(gap) {

      const viewportWidth = window.innerWidth;
      const viewportHeight = window.innerHeight;
      const size = Math.floor(viewportWidth / 8);

      // Calculate the number of rows and columns
      const rows = Math.floor((viewportHeight - 40) / (size + gap));
      const cols = Math.floor((viewportWidth - 40) / (size + gap));

      console.log(size);
      return { rows, cols, size };
    }

    // Main function to initialize the grid
    function initGrid() {
      const gap = 20;

      const { rows, cols, size } = calculateGridSize(gap);
      const grid = createGrid(rows, cols, size, gap);

      // Append the grid to the body
      document.body.appendChild(grid);
    }

    // Initialize the grid when the DOM is ready
    document.addEventListener('DOMContentLoaded', initGrid);