function oldmakeid(length) {
    let result = '';
    const characters = 'ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789';
    const charactersLength = characters.length;
    let counter = 0;
    while (counter < length) {
      result += characters.charAt(Math.floor(Math.random() * charactersLength));
      counter += 1;
    }
    return result;
}
function makeid(length) {
    const wdrs = words.filter( (w) => w.length == length);
    if(wdrs.length) {
        shuffle(wdrs);
        return wdrs[0]
    } 
    const w = oldmakeid(length)
    return w
}
function shuffle(array) {
  for (let i = array.length - 1; i > 0; i--) {
    let j = Math.floor(Math.random() * (i + 1));
    [array[i], array[j]] = [array[j], array[i]];
  }
}
const ps = []
const words = [
    "rage",
    "grève",
    "colère",
    "révolte",
    "histoire",
    "politique",
    "révolution",
    "technologie", 
    "développement",
    "exploitation",'État', 'armée', 'Ordre', 'Grève', 'Univers', 'progrès', 'Réforme', 'Royauté', 'Pauvreté', 'Anarchie', 'Évolution', 'phénomène', 'révolution', 'Révolution', 'Les foules', 'Répression', 'Renaissance', 'Politiciens', 'patriotisme', 'aristocratie', 'magistrature', 'paix sociale', 'Parole libre', 'Action libre', 'administration', 'Internationale', 'Grève générale', 'action des lois', 'Esprit de corps', 'Dernières luttes', 'Du pain pour tous', 'Idéal de la pensée', 'Espoirs illogiques', 'Suffrage universel', 'Droit du plus fort', 'volonté d’un maître', 'Les Forces en lutte', 'Evénements complexes', 'Révolution française', 'Élite intellectuelle', 'idéal évolutionniste', 'Sociétés anarchistes', 'Commune de Montreuil', 'Révolution régressive', 'Révolutions de palais', 'ennemis de la famille', 'Révolution progressive', 'Révolution instinctive', 'Conjurations de partis', 'le but révolutionnaire', 'ennemis de la religion', 'Révolutions conscientes', 'ennemis de la propriété', 'État social contemporain', 'Suprême raison  des rois', 'Impuissance des ouvriers', 'Solidarité des grévistes', 'Associations coopératives', 'L’ordre dans le mouvement', 'Evolutionnistes hypocrites', 'Toute-puissance du capital', 'Associations communautaires', 'Grève des drapiers de Vienne', 'Appréciation vraie des choses', 'Alliance du maître et du valet', 'Inflexibilité forcée du capital', 'Situation présente et prochain avenir', 'Puissance de la fascination religieuse', 'Suffisance et surabondance des ressources', 'La science vécue et la science officielle', 'Enseignement de la nature et de la société', 'transformations apparentes des institutions', 'Logique du fonctionnement des États modernes', 'Saisie des usines comme propriété collective', 'Difficultés d’adaptation à un milieu nouveau', 'Enseignement confié aux ennemis de la science']

function buildElement(len, target){
    const el = document.createElement("p")
    let text = makeid(len);
    let lettres = text.split('').map(l => {
        return l == " " ? `<span> </span>` : `<span>${l}</span>`
    });
    el.innerHTML = lettres.join("");
    const elements = []
    el.querySelectorAll('span').forEach((span, idx) => {
        elements.push({ "el": span, "idx": idx, "y": 0 })
    })
    document.body.appendChild(el)
    ps.push([el, elements])
    
    return elements
}

const textarea = document.querySelector('textarea')

function createEasedValues(start, end, steps, easingType = 'ease-in') {
    const values = [];
    const delta = end - start;
    const easingFunctions = {
        'ease-in': t => t * t,  
        'ease-out': t => t * (2 - t),
        'ease-in-out': t => t < 0.5 ? 2 * t * t : -1 + (4 - 2 * t) * t  
    };
    const ease = easingFunctions[easingType] || easingFunctions['ease-in'];
    for (let i = 0; i <= steps; i++) {
        const t = i / steps;  // normalized time (from 0 to 1)
        const easedT = ease(t);  // apply easing
        values.push(start + easedT * delta);  // interpolate between start and end
    }
    return values;
}



function interpolateYValues(elements) {
    const minValue = 0;
    const maxValue = 20 + elements.length
    let css = "";
    // indices
    const indices = [0, Math.floor(elements.length / 2), elements.length - 1 ];
    
    // Set random y values between minValue and maxValue for the 3 random indices
    indices.forEach(index => {
        elements[index].y = Math.floor(Math.random() * (maxValue - minValue + 1)) + minValue;
    });


    // 2: Interpolate values between random indices
    for (let i = 0; i < indices.length - 1; i++) {
        const startIdx = indices[i];
        const endIdx = indices[i + 1];

        const startY = elements[startIdx].y;
        const endY = elements[endIdx].y;

        const interpolatedValues = createEasedValues(startY, endY, endIdx - startIdx, 'ease-in-out');

        // 3: Assign the interpolated y values to the elements between startIdx and endIdx
        for (let j = startIdx; j <= endIdx; j++) {
            // let val = 
            const val = interpolatedValues[j - startIdx];
            if(isNaN(val)) {
                elements[j].el.style.color = "red"    
            }
            elements[j].y = val;
            elements[j].el.style.setProperty("--t", val );
            css += `.t${elements.length} .l${j + 1}{--t:${val}}`
        }
    }
    return css
}

for(let a = 5; a < 45; a++  ) {
    const elements = buildElement(a, false);
    const css = interpolateYValues(elements);
    textarea.value = textarea.value + "\n" + css
    console.log(css)
}

ps.forEach(p => {
    p[0].onclick = () => {
        const css = interpolateYValues(p[1]);
        console.log(css)
    }
});
