const el = document.querySelector('main');
let h = el.offsetHeight;
const steps = 40;


function measure() {
  h = el.offsetHeight
  el.style.setProperty('--h', el.offsetHeight + "px");
}
function setPolygons(){
  const left = document.querySelector('.left');
  const right = document.querySelector('.right');
  left.style.setProperty("--polygon", getPolygon("left"));
  right.style.setProperty("--polygon", getPolygon("right"));
}
function getPolygon(dir){
  const start_x = dir == "left" ? 100 : 0;
  const end_x = dir == "left" ? 0 : 100;
  let polygon = "polygon(" + end_x + "% 0%, ";
  for (let i = 1; i < steps; i++) {
    var x = i % 2 ? start_x : end_x;
    var y = 100/(steps - 1) * i;
    polygon += x + "% ";
    polygon +=  y + "%";
    polygon += ", ";
  }
  polygon += end_x + "% 100%)";
  console.log(polygon);
  return polygon;
}
window.onload = (event) => {
  setPolygons();
  
  measure();
  // setting polygon changes element height,
  // so we’ve got to re-measure until customProperty equals element height
  let i = setInterval(() => {
    if(h <= el.offsetHeight) {
      measure();
    } else {
      console.log(h, el.offsetHeight);
      clearInterval(i);
    }
  }, 450);
};