const svg = document.createElementNS("http://www.w3.org/2000/svg", 'svg');
const l1 = document.createElementNS("http://www.w3.org/2000/svg", 'line');
const l2 = document.createElementNS("http://www.w3.org/2000/svg", 'line');
let w, h;

document.body.appendChild(svg)
svg.appendChild(l1)
svg.appendChild(l2)


// init
function init() {
    w = window.innerWidth; 
    h = window.innerHeight;
    svg.setAttributeNS("http://www.w3.org/2000/svg", 'viewbox', `0 0 ${w} ${h}`);
}
init()

l1.setAttribute("x1", 0);
l1.setAttribute("y1", 0);
l1.setAttribute("x2", w/2);
l1.setAttribute("y2", h/2);
l2.setAttribute("x1", w/2);
l2.setAttribute("y1", h/2);
l2.setAttribute("x2", w);
l2.setAttribute("y2", 0);

document.addEventListener('mousemove', (e) => {
    const is_down = e.clientY > h / 2;
    l1.setAttribute("x1", e.clientX);
    l1.setAttribute("y1", e.clientY);
    l1.setAttribute("x2", 0);
    l1.setAttribute("y2", is_down ? 0 : h);

    l2.setAttribute("x1", e.clientX);
    l2.setAttribute("y1", e.clientY);
    l2.setAttribute("x2", w);
    l2.setAttribute("y2", is_down ? 0 : h);
})

window.addEventListener('resize', () => {
    init()
})