var divA = document.querySelector("#a");
var divB = document.querySelector("#b");
var arrowLeft  = document.querySelector("#arrowLeft");
var arrowRight = document.querySelector("#arrowRight");

// funky random
function randPos(e){
  var left = Math.round( Math.random() * (window.innerWidth  - e.getBoundingClientRect().width  ));
  var tp  = Math.round( Math.random() * (window.innerHeight - e.getBoundingClientRect().height ));
  e.style.left = left + "px";
  e.style.top = tp + "px";
}
randPos(divA);
randPos(divB);
var btn = document.querySelector("button");
btn.onclick = () => {
  randPos(divA);
  randPos(divB);
  drawConnector();
}

var drawConnector = function() {
  var posnALeft = {
    x: divA.offsetLeft - 8,
    y: divA.offsetTop  + divA.offsetHeight / 2
  };
  var posnARight = {
    x: divA.offsetLeft + divA.offsetWidth + 8,
    y: divA.offsetTop  + divA.offsetHeight / 2    
  };
  var posnBLeft = {
    x: divB.offsetLeft - 8,
    y: divB.offsetTop  + divB.offsetHeight / 2
  };
  var posnBRight = {
    x: divB.offsetLeft + divB.offsetWidth + 8,
    y: divB.offsetTop  + divB.offsetHeight / 2
  };
  var bend = 100 + Math.abs(posnBRight.x - posnARight.x) / 3;
  var dStrLeft =
      "M" +
      (posnALeft.x) + "," + (posnALeft.y) + " " +
      "C" +
      (posnALeft.x - bend) + "," + (posnALeft.y) + " " +
      (posnBLeft.x - bend) + "," + (posnBLeft.y) + " " +
      (posnBLeft.x) + "," + (posnBLeft.y);
  arrowLeft.setAttribute("d", dStrLeft);
  bend = 100 + Math.abs(posnBRight.x - posnARight.x) / 3;
  var dStrRight = 
      "M" +
      (posnBRight.x) + "," + (posnBRight.y) + " " +
      "C" +
      (posnBRight.x + bend) + "," + (posnBRight.y) + " " +
      (posnARight.x + bend) + "," + (posnARight.y) + " " +
      (posnARight.x) + "," + (posnARight.y);
  arrowRight.setAttribute("d", dStrRight);
};


drawConnector();