const b = document.body;
let w = window.innerWidth;
let h = window.innerHeight;

b.addEventListener('mousemove', (_) => {
    b.style.setProperty('--x', (_.clientX * 100 / w).toFixed(2) + "%" );
    b.style.setProperty('--y', (_.clientY * 100 / h).toFixed(2) + "%" );
    b.style.setProperty('--grad', grad());
})

b.style.setProperty('--grad', grad());
window.addEventListener('resize', () => {
    w = window.innerWidth;
    h = window.innerHeight;
});

function grad() {
    const colors = ["yellow", "green", "blue", "pink", "red", "purple", "orange", "cyan"];
    const steps = Math.floor(Math.random() * (8 - 4 + 1)) + 4;

    let cssString = "";
    let startDeg = 0;

    for (let i = 0; i < steps; i++) {
        const endDeg = Math.floor(Math.random() * (360 - startDeg) / (steps - i)) + startDeg; // Ensures the range covers 360deg
        const color = colors[Math.floor(Math.random() * colors.length)];
        cssString += `${color} ${startDeg}deg ${endDeg}deg`;
        if (i < steps - 1) cssString += ", "
        startDeg = endDeg; 
    }

    if (startDeg < 360) {
        cssString += `, ${colors[Math.floor(Math.random() * colors.length)]} ${startDeg}deg 360deg`;
    }

    return cssString;
}
