var canvas = document.getElementById('myCanvas');
var context = canvas.getContext('2d');

function rwd(){
  var w = window.innerWidth;
  var h = window.innerHeight;
  canvas.setAttribute("width",w);
  canvas.setAttribute("height",h);
  function r(min, max) {
      return Math.floor(Math.random() * (max - min + 1)) + min;
  }


  context.beginPath();
  context.lineWidth = 10;
  context.strokeStyle = 'red';

  // R1 
  const r1 = [-10, r(h/2, h)];
  context.moveTo(r1[0],r1[1]);
  // R1 -> R2
  const r2 = [r(20, w/6), 0];
  context.lineTo(r2[0], r2[1]);
  // R2 -> R3
  const r23 = [r(r2[0] + 150, w/3), r(h/6, h/2)];
  const r3 = [r(50, r2[0]), r(h/2, h - h/6)];
  context.bezierCurveTo(r2[0], r2[1], r23[0], r23[1], r3[0], r3[1]);
  // R3 -> R4
  const r4 = [r(r3[0], w/3), h + 10];
  context.lineTo(r4[0], r4[1]);

  
  // W1  
  const w1 = [r(r2[0] + 50, w/3), -10];
  const w2 = [r(r4[0], w/3), h + 10];
  const w3 = [r(w1[0] + 10, w/1.8), r(w/10, w/6)];
  const w4 = [r(w/2, w/1.5), h + 10];
  const w5 = [r(w3[0] + 50, w/1.2), -10];
  context.moveTo(w1[0],w1[1]);  
  context.lineTo(w2[0], w2[1]); 
  context.lineTo(w3[0], w3[1]);
  context.lineTo(w4[0], w4[1]);
  context.lineTo(w5[0], w5[1]);
  
  // D
  const d1 = [r(w5[0] + 20, w/1.1), -10];
  const d2 = [r(w5[0] + 20, w/1.1), h + 10];
  const d121 = [w, r(h/2 - 50,h/2) + 10];
  const d122 = [w, r(h/2, h/2 + 50) + 10];
  context.moveTo(d1[0], d1[1]);  
  context.lineTo(d2[0], d2[1]);
  context.bezierCurveTo(d121[0], d121[1], d121[0], d121[1], d1[0], d1[1]);
  context.stroke();
  


}
rwd();
window.addEventListener("resize", function(){
  rwd();
})