const cols = 5;
const rows = 14;

let images = [];
for (let i = 1; i <= cols * rows; i++) {
  let num = i.toString().padStart(4, '0');
  images.push(`https://ateliers.esad-pyrenees.fr/web/archives/2024-2025/Ruisseau/baudreix_videos/frames/${num}.gif`);
}

let imgObjects = [];
let loaded = false;
const imgRatio = 400 / 225;

let currentWeights = Array(cols).fill(1);  // initial equal widths
let targetWeights = Array(cols).fill(1);

function preload() {
  for (let i = 0; i < images.length; i++) {
    imgObjects[i] = loadImage(images[i]);
  }
}

function setup() {
  createCanvas(windowWidth, windowHeight);
  imageMode(CORNER);
}

function draw() {
  if (imgObjects.length < 50) {
    background(20);
    fill(255);
    textAlign(CENTER, CENTER);
    text('Loading images...', width / 2, height / 2);
    return;
  }

  background(30);
  updateTargetWeights();
  animateColumnWeights();

  const scrollOffset = map(mouseY, 0, height, 0, rows * (height / rows) - height);

  const colWidths = calculatePixelWidths();
  let xOffset = 0;
  let imgIndex = 0;

  let yOffset = scrollOffset;  // Scroll effect failed

  for (let col = 0; col < cols; col++) {
    const colW = colWidths[col];
    const imgH = colW / imgRatio;

    for (let i = 0; i < rows; i++) {
      const img = imgObjects[imgIndex];
      if (img) {
        const y = yOffset +  i * imgH;
        image(img, xOffset, y, colW, imgH);
      }
      imgIndex++;
    }

    xOffset += colW;
  }
}

function getYStart(){
  return height - mouseY;
}


function updateTargetWeights() {
  let mouseCol = floor(map(mouseX, 0, width, 0, cols));
  mouseCol = constrain(mouseCol, 0, cols - 1);

  const maxWeight = 2; // hovered col
  const minWeight = 0.8; // farest col

  for (let i = 0; i < cols; i++) {
    let dist = abs(i - mouseCol);
    targetWeights[i] = lerp(maxWeight, minWeight, dist / (cols - 1));
  }

  // Normalize so that total weight = cols
  normalizeWeights(targetWeights);
}

function animateColumnWeights() {
  for (let i = 0; i < cols; i++) {
    // lerp transition !
    currentWeights[i] = lerp(currentWeights[i], targetWeights[i], 0.05);
  }

  normalizeWeights(currentWeights);
}

function calculatePixelWidths() {
  const totalWeight = currentWeights.reduce((sum, w) => sum + w, 0);
  return currentWeights.map(w => (w / totalWeight) * width);
}

function normalizeWeights(weights) {
  const sum = weights.reduce((a, b) => a + b, 0);
  for (let i = 0; i < weights.length; i++) {
    weights[i] = (weights[i] / sum) * cols;
  }
}

function windowResized() {
  resizeCanvas(windowWidth, windowHeight);
}
