let time = 0;
let breathCycle = 0;

function setup() {
  createCanvas(800, 600);
  frameRate(30);
}

function draw() {
  background(240);
  
  // Update breath cycle (0 to 2PI)
  breathCycle = (breathCycle + 0.02) % (2 * PI);
  time += 0.05;
  
  // Calculate base values affected by breathing
  let baseHeight = map(sin(breathCycle), -1, 1, 300, 400);
  let baseGap = map(cos(breathCycle), -1, 1, 20, 40);
  let baseCurve = map(sin(breathCycle), -1, 1, 0.001, 0.003);
  
  // Draw multiple lines
  let x = 50; // Starting x position
  
  while (x < width - 50) {
    // Calculate height variation based on position
    let heightVar = baseHeight + sin(x * 0.01 + time) * 50;
    
    // Calculate curve intensity based on position
    let curveIntensity = baseCurve * (x / width);
    
    // Draw a curvy line
    drawCurvyLine(x, heightVar, curveIntensity);
    
    // Increment x position with breathing-affected gap
    x += baseGap + (sin(x * 0.02 + time) * 10);
  }
}

function drawCurvyLine(x, height, curveIntensity) {
  let y = (height + 600) / 2; // Center point
  
  beginShape();
  noFill();
  stroke(40);
  strokeWeight(2);
  
  // Create points for the curvy line
  for (let py = y - height/2; py < y + height/2; py += 5) {
    let xOffset = sin((py - y) * curveIntensity + time) * 30;
    curveVertex(x + xOffset, py);
  }
  
  endShape();
}