const audio = document.querySelector("#monaudio");
const play_btn = document.querySelector("#play");
const timecode = document.querySelector("#timecode");
const form = document.querySelector("form");

play_btn.addEventListener('click', () => {
    audio.play();
    audio.focus()
})

form.addEventListener('submit', (e) => {
    e.preventDefault();
    const val = timecode.value;
    playTimecode(val);
})

const chapters = document.querySelectorAll('[data-chapter]');
chapters.forEach((chapter_btn)=> {
    chapter_btn.onclick = () => {
        playTimecode(chapter_btn.dataset.chapter);
    }
})


function playTimecode(val){
    
    // split minutes secondes
    const ms = val.split(/,|:./);
    let sec;
    if(ms.length > 1){
        console.log("minutes + secondes")
        console.log(ms[0])
        console.log(ms[1])
        sec = parseInt(ms[0]) * 60 + parseInt(ms[1])
    } else {
        console.log("secondes")
        console.log(ms[0])
        sec = parseInt(ms[0]);
    }
    console.log(sec)
        
    // valider la valeur
    audio.currentTime = sec;
    audio.play();
    audio.focus()
}