const sections = document.querySelectorAll('section');

function handleIntersection(sections) {
  sections.map((section) => {
    if (section.isIntersecting) {
        section.target.classList.add('visible');
      if(section.target.id == "truc") {
        section.target.classList.add('red');
        section.target.querySelector('video').play()
      }
    } else {      
      section.target.classList.remove('visible')
    }
  });
}

const observer = new IntersectionObserver(handleIntersection,  { threshold: 0.4 });

sections.forEach(section => observer.observe(section));