let items = [], // liste des éléments
  current = null; //élément courrant

document.querySelectorAll("div").forEach( (div) => {

  // stocke tous les divs avec leurs positions dans la liste “items”
  let style = window.getComputedStyle(div);
  let item = {
    div: div,
    col: parseInt(style.getPropertyValue('--col')),
    row: parseInt(style.getPropertyValue('--row'))
  }
  items.push(item)

  // au clic sur un div, on scrolle vers lui
  div.onclick = () => {
    showItem(item)
  }
})

// fonction pour afficher
function showItem(item){
  current = item;
  item["div"].scrollIntoView({behavior: "smooth", block: "end", inline: "end"}) 
}


// au démarrage, on scrolle vers le premier div
setTimeout(()=>{
  showItem(items[0]);  
}, 1000)

// navigation au clavier (avec les flèches)
window.addEventListener("keydown", (e) => {
  let possibles = [];
  switch (e.key) {
    case "ArrowRight":
      possibles = items.filter( item => item['col'] > current["col"] && item['row'] == current["row"] );
      break;
    case "ArrowLeft":
      possibles = items.filter( item => item['col'] < current["col"] && item['row'] == current["row"] ).reverse();
      break;
    case "ArrowDown":
      possibles = items.filter( item => item['col'] == current["col"] && item['row'] > current["row"] );
      break;
    case "ArrowUp":
      possibles = items.filter( item => item['col'] == current["col"] && item['row'] < current["row"] ).reverse();
      break;
  }
  if(['ArrowRight', 'ArrowLeft', "ArrowUp", "ArrowDown"].indexOf(e.key) > -1 && possibles.length > 0) {
    showItem(possibles[0])
  }
})