const images = document.querySelectorAll('img'); // toutes les images
const score_element = document.querySelector('#score'); // élément pour afficher le score
let score = 0; // score initial

// pour chaque image
images.forEach(function(image){
  image.onclick = () => {
    // le score spécifique à chaque image est stocké dans l’élément HTML, dans un attribut data-score, accessible en js grace à la propriété “dataset” (qui renvoie une chaine de caractères)
    // la focntion parseInt() permet de transformer une chaine en nombre entier
    const howmuch = parseInt(image.dataset.score);
    // on ajoute au score actuel la valeur obtenue
    score += howmuch;
    // on modifie le contenu textuel de l’élément #score
    score_element.textContent = score;
  }
})