// sélectionne tous les `button` dotés d’un attribut “data-show”
// voir “sélecteurs d’attribut” : https://ateliers.esad-pyrenees.fr/web/pages/ressources/css/selectors/
const elements = document.querySelectorAll('button[data-show]');

// pour chaque bouton :
elements.forEach((element) => {

  element.onmouseover = () => {
    // on enregistre l’id de l’élément cible, 
    // stocké dans l’attribut data-show de l’élément
    var target_selector = element.dataset.show;
    // on sélectionne cet élément
    var target = document.querySelector(target_selector);
    // on lui ajoute la class “visible”
    target.classList.add('visible');
  }

  element.onmouseout = () => {
    var target_selector = element.dataset.show; 
    var target = document.querySelector(target_selector);
    target.classList.remove('visible');
  }  
  
})