let down;
let dot;
let timeTaken = 0;
let isMouseDown = false, 
  needForRAF = true; 

function mouseDown(e) {
  isMouseDown = true;
  down = Date.now();
  if (needForRAF && isMouseDown) {
    mydot = document.createElement('div');
    mydot.className = "dot";
    mydot.style.left = e.clientX + "px";
    mydot.style.top = e.clientY + "px";
    document.body.appendChild(mydot);
    dot = mydot;
    needForRAF = false;   
    requestAnimationFrame(update); 
  };
}

function mouseUp(e) {
  e.preventDefault();
  isMouseDown = false; 
}


function update() {
  var now = Date.now() - down;
  var scale = 1 + now/1000;
  dot.style.transform= ' translate(-50%, -50%) scale(' + scale + ')';
  if(isMouseDown) {
		requestAnimationFrame(update);
	} else {
    needForRAF = true;
  }
}

document.addEventListener("mousedown", mouseDown);
document.addEventListener("mouseup", mouseUp);