// liste des points avec audio_urls associées 
const items = [
  {
    title: "Audio 1",
    position : [50.849666,4.351322],
    image: "images/point-1.png",
    audio: new Audio("https://assets.codepen.io/4340165/00.mp3")
  },
  {
    title: "Audio 2",
    position: [50.848691, 4.356862],
    image: "images/point-2.png",
    audio: new Audio("https://assets.codepen.io/4340165/Fluxus-Anthology_07_Robert-Filliou.mp3")
  }
];


// actions

var panorama = null;
panorama.addEventListener('position_changed', () => {
  
  items.forEach((item) => {
    var title = markers[i].title,
        position = markers[i].position;
    
    const lnglat = [panorama.getPosition().lat(), panorama.getPosition().lng()];

    var whereweare = turf.point(lnglat);
    var whereistheaudiopoint = turf.point(position);
    var distance = turf.distance(whereweare, whereistheaudiopoint, {units: 'meters'});
    //console.log(distance)

    if (distance < 20) {
      fadeAndPlay(item.audio)
      
    } 
  })


})
  
// variable pour l’élément audio en cours de lecture
var currentAudio = null;

// fonction pour "fadein" le nouvel audio et "fadeout" le currentAudio
function fadeAndPlay(newAudio){
  newAudio.play();
  fade(newAudio, "in");
  if(currentAudio !== null) {
    fade(currentAudio, "out");
  }
  // établit le nouveau en tant que currentAudio
  currentAudio = newAudio;
}

// helper fader
function fade(audio, direction) {
    var variation = 0.1;
    var newVolume = direction == "in" ? 0 : 1;
    var fadeAudio = setInterval(function () {
      
      if(direction == "in" && newVolume <= 1 - variation){
        newVolume += variation;
        audio.volume = newVolume;
      } 
      if(direction == "out"){    
        if(newVolume > 0 + variation){
          // décroit
          newVolume -= variation;
          audio.volume = newVolume;    
        } else {
          // pause
          audio.volume = 0;
          audio.pause(); 
          audio.currentTime=0;
          clearInterval(fadeAudio);
        }    
      }
      
      
    }, 200);
}